<div class="wrap">
    <div class="bpcir-admin-wrapper">

    <h2>Configuration - Redirector</h2>       
    
    <?php // settings_errors(); ?>  

    <?php
        $active_tab = isset( $_GET[ 'tab' ] ) ? $_GET[ 'tab' ] : 'inactivity';
    ?>

    <h2 class="nav-tab-wrapper">        
        <a href="?page=redirector-options&tab=inactivity" class="nav-tab <?php echo $active_tab == 'inactivity' ? 'nav-tab-active' : ''; ?>">Inactivity</a>
        <a href="?page=redirector-options&tab=early_leave" class="nav-tab <?php echo $active_tab == 'early_leave' ? 'nav-tab-active' : ''; ?>">Early Leave</a>
        <a href="?page=redirector-options&tab=triggers" class="nav-tab <?php echo $active_tab == 'triggers' ? 'nav-tab-active' : ''; ?>">Triggers</a>
        <a href="?page=redirector-options&tab=license" class="nav-tab <?php echo $active_tab == 'license' ? 'nav-tab-active' : ''; ?>">License</a>
        <a href="?page=redirector-options&tab=documentation" class="nav-tab <?php echo $active_tab == 'documentation' ? 'nav-tab-active' : ''; ?>">Documentation</a>
    </h2>  

    <form id="bpcir_config-form" method="post" action="options.php">

        <?php settings_fields( 'bpcir_options_group' ); // options group  ?>        

        <?php 
            $license_status = isset( $bpcir_options['license']['status'] ) ? $bpcir_options['license']['status'] : 'inactive';
            if ( $license_status !== 'valid' ) : 
        ?>
        <div class="card" style="max-width: 100%; padding: 20px; margin-bottom: 20px; background-color: #f0f6fc; border: 1px solid #cce5ff;">
            <h2 style="color: #005b99; margin-top: 0;"><?php _e('🚀 Go PRO - Unlock Full Power', 'bpcir'); ?></h2>
            <p><?php _e('The free version is great, but the PRO version takes your conversion rate to the next level with aggressive triggers:', 'bpcir'); ?></p>
            
            <ul style="list-style-type: disc; margin-left: 20px; margin-bottom: 20px;">
                <li><strong>✅ Back Button Redirect:</strong> <?php _e('The #1 way to capture mobile traffic! Redirects users when they click "Back" on their browser.', 'bpcir'); ?></li>
                <li><strong>✅ Scroll Redirect:</strong> <?php _e('Trigger an offer when a user scrolls down a certain percentage of the page.', 'bpcir'); ?></li>
                <li><strong>✅ Copy/Paste Redirect:</strong> <?php _e('Redirect users who copy content from your site (often competitors or highly interested users).', 'bpcir'); ?></li>
                <li><strong>✅ Priority Support:</strong> <?php _e('Get help directly from the developers.', 'bpcir'); ?></li>
            </ul>

            <a href="https://blogpascher.com/produit/redirector-pro" target="_blank" class="button button-primary button-hero">
                <?php _e('Get BPC Redirector PRO Now', 'bpcir'); ?>
            </a>
        </div>
        <?php endif; ?>

        <div class="inactivity" <?php echo $active_tab != "inactivity" ? 'style="display:none;' : ""; ?>>
            <!--h2 class="title">Inactivity</h2-->
            <p>
                <strong>
                    <?php _e( 'These options manage the behavior of the site when a user remains « inactive » for the below configured amount of time.', 'bpcir' ) ?>
                </strong>
            </p>
            <table class="form-table">
                <tbody>
                    <tr class="in-redirect-url">
                        <th scope="row"><?php _e( 'URL', 'bpcir' ); ?></th>
                        <td>
                            <textarea name="bpcir_options[inactivity][url]" id="in_redirect_url" cols="50" rows="3"><?php echo $bpcir_options["inactivity"]["url"]; ?></textarea>
                            <a class="bpc-repeater-add" href="#">Add</a>
                            <p class="description"><?php _e( "The default link to redirect idle visitors. Empty value disables inactivity feature.", 'bpcir' ) ?></p>
                        </td>
                    </tr>

                    <?php if($in_urls_count > 0): ?>
                        <?php foreach($in_urls_links as $i => $value): ?>
                            <tr style="border-bottom:1px solid #dedede" class="in-redirect-urls">
                                <th scope="row"><?php _e( 'URL', 'bpcir' ); ?></th>
                                <td>
                                    <div style="display:block;">
                                        <div style="width:40%;float:left;"><textarea name="bpcir_options[inactivity][urls][link][]" cols="50" rows="3"><?php echo isset($in_urls_links[$i]) ? $in_urls_links[$i] : ""; ?></textarea>                                        </div>
                                        <div style="width:20%;float:left;">
                                            <span><b>Timeout :</b> </span>
                                            <input type="text" name="bpcir_options[inactivity][urls][timeout][]" id="url_timeout" class="small-text" 
                                                value="<?php echo isset($in_urls_timeouts[$i]) ? $in_urls_timeouts[$i] : ""; ?>">
                                            <span class="description">seconds</span>
                                        </div>
                                        <div style="width:25%;float:left;">
                                        <a class="bpc-repeater-add" href="#">Add</a>
                                    <a class="bpc-repeater-remove" href="#">Remove</a>
                                        </div>
                                    </div>
                                </td>            
                            </tr>
                        <?php endforeach; ?>
                    <?php endif; ?>

                    <tr>
                        <th scope="row"><?php _e( 'Cookie Name', 'bpcir' ); ?></th>
                        <td>
                            <input type="text" name="bpcir_options[inactivity][cookie]" 
                                id="el_cookie" class="medium-text" 
                                value="<?php 
                                    echo isset($bpcir_options['inactivity']['cookie']) ? 
                                    sanitize_text_field( $bpcir_options['inactivity']['cookie'] ) : ""; 
                                ?>">
                            <p class="description"><?php _e( "Inactivity cookie name. Empty defaults to value bpcito.", 'bpcir' ) ?></p>
                        </td>               
                    </tr>
                    <tr>
                        <th scope="row"><?php _e( 'Cookie expiration', 'bpcir' ); ?></th>
                        <td>
                            <input type="text" name="bpcir_options[inactivity][cookieExp]" 
                                id="el_cookie" class="small-text" 
                                value="<?php 
                                    echo isset($bpcir_options['inactivity']['cookieExp']) ? 
                                    sanitize_text_field( $bpcir_options['inactivity']['cookieExp'] ) : ""; 
                            ?>">
                            <span class="description">days</span>
                            <p class="description"><?php _e( "Cookie expiration delay. Empty defaults to value 30.", 'bpcir' ) ?></p>
                        </td>               
                    </tr>
                    <tr>
                        <th scope="row"><?php _e( 'Timeout delay', 'bpcir' ); ?></th>
                        <td>
                            <input type="text" name="bpcir_options[inactivity][timeout]" 
                                id="paypal_email" class="small-text" 
                                value="<?php 
                                    echo isset($bpcir_options['inactivity']['timeout']) ? 
                                    sanitize_text_field( $bpcir_options['inactivity']['timeout'] ) : ""; 
                            ?>">
                            <span class="description">seconds</span>
                            <p class="description"><?php _e( "The time within which a user that has not interacted with the site is considered « inactive ». Empty or 0 defaults to value 300.", 'bpcir' ) ?></p>
                        </td>               
                    </tr>
                </tbody>
            </table>
        </div>

        <div class="earlyLeave" <?php echo $active_tab != "early_leave" ? 'style="display:none;' : ""; ?>>
            <!--h2 class="title">Early leaves</h2-->
            <p>
                <strong>
                    <?php _e( 'These options manage the behavior of the site when a user leaves the site without spending the minimun amount of time.', 'bpcir' ) ?>
                </strong>
            </p>
            <table class="form-table">
                <tbody>
                    <tr class="el-redirect-url">                 
                        <th scope="row"><?php _e( 'URL', 'bpcir' ); ?></th>
                        <td>
                            <textarea name="bpcir_options[earlyLeave][url]" id="el_redirect_url" cols="50" rows="3"><?php echo $bpcir_options["earlyLeave"]["url"]; ?></textarea>
                            <a class="bpc-repeater-add" href="#">Add</a>
                            <p class="description"><?php _e( "The default link to redirect visitors who leave early. Empty value disables early leave feature.", 'bpcir' ) ?></p>                        
                        </td>
                    </tr>

                    <?php  if(isset($bpcir_options["earlyLeave"]["urls"])): ?>
                        <?php foreach( $bpcir_options["earlyLeave"]["urls"] as $url ) :  ?>
                            <tr class="el-redirect-urls">
                                <th scope="row"><?php _e( 'URL', 'bpcir' ); ?></th>
                                <td>
                                    <textarea name="bpcir_options[earlyLeave][urls][]" cols="50" rows="3"><?php echo $url; ?></textarea>
                                    <a class="bpc-repeater-add" href="#">Add</a>
                                    <a class="bpc-repeater-remove" href="#">Remove</a>                                    
                                </td>               
                            </tr>
                        <?php endforeach; ?>
                    <?php endif;  ?>

                    <tr>
                        <th scope="row"><?php _e( 'Cookie Name', 'bpcir' ); ?></th>
                        <td>
                            <input type="text" name="bpcir_options[earlyLeave][cookie]" 
                                id="el_cookie" class="medium-text" 
                                value="<?php 
                                    echo isset($bpcir_options['earlyLeave']['cookie']) ? 
                                    sanitize_text_field( $bpcir_options['earlyLeave']['cookie'] ) : ""; 
                                ?>">
                            <p class="description"><?php _e( "Early leave cookie name. Empty defaults to value bpcel.", 'bpcir' ) ?></p>
                        </td>               
                    </tr>
                    <tr>
                        <th scope="row"><?php _e( 'Cookie expiration', 'bpcir' ); ?></th>
                        <td>
                            <input type="text" name="bpcir_options[earlyLeave][cookieExp]" 
                                id="el_cookie" class="small-text" 
                                value="<?php 
                                    echo isset($bpcir_options['earlyLeave']['cookieExp']) ? 
                                    sanitize_text_field( $bpcir_options['earlyLeave']['cookieExp'] ) : ""; 
                            ?>">
                            <span class="description">days</span>
                            <p class="description"><?php _e( "Cookie expiration delay. Empty defaults to value 30.", 'bpcir' ) ?></p>
                        </td>               
                    </tr>
                    <tr>
                        <th scope="row"><?php _e( 'Timeout delay', 'bpcir' ); ?></th>
                        <td>
                            <input type="text" name="bpcir_options[earlyLeave][timeout]" 
                                id="paypal_email" class="small-text" 
                                value="<?php 
                                    echo isset($bpcir_options['earlyLeave']['timeout']) ? 
                                    sanitize_text_field( $bpcir_options['earlyLeave']['timeout'] ) : ""; 
                            ?>">
                            <span class="description">seconds</span>
                            <p class="description"><?php _e( "The time within which leaving the site is considered « premature ». Empty or 0 defaults to value 15.", 'bpcir' ) ?></p>
                        </td>               
                    </tr>
                    <tr>
                        <th scope="row"><?php _e( 'Exit intent zone height', 'bpcir' ); ?></th>
                        <td>
                            <input type="text" name="bpcir_options[earlyLeave][eiZoneHeight]" 
                                id="paypal_email" class="small-text" 
                                value="<?php 
                                    echo isset($bpcir_options['earlyLeave']['eiZoneHeight']) ? 
                                    sanitize_text_field( $bpcir_options['earlyLeave']['eiZoneHeight'] ) : ""; 
                            ?>">
                            <span class="description">pixels</span>
                            <p class="description"><?php _e( "The height of the exit intent capture zone, from the top of the browser going towards the bottom. Empty or 0 defaults to value 50.", 'bpcir' ) ?></p>
                        </td>               
                    </tr>
                    <tr>
                        <th scope="row"><?php _e( 'Exit intent zone elevation', 'bpcir' ); ?></th>
                        <td>
                            <input type="text" name="bpcir_options[earlyLeave][zindex]" 
                                id="paypal_email" class="medium-text" 
                                value="<?php 
                                    echo isset($bpcir_options['earlyLeave']['zindex']) ? 
                                    sanitize_text_field( $bpcir_options['earlyLeave']['zindex'] ) : ""; 
                            ?>">
                            <p class="description"><?php _e( "The elevation of the exit intent capture zone. Empty or 0 defaults to value 999999.", 'bpcir' ) ?></p>
                        </td>               
                    </tr>
                </tbody>
            </table>
        </div>

        <div class="triggers" <?php echo $active_tab != "triggers" ? 'style="display:none;' : ""; ?>>
            <?php 
                $license_status = isset( $bpcir_options['license']['status'] ) ? $bpcir_options['license']['status'] : 'inactive';
                if ( $license_status !== 'valid' ) : 
            ?>
                <div class="notice notice-error inline">
                    <p><?php _e( 'These features require a valid license key. Please activate your license in the "License" tab.', 'bpcir' ); ?></p>
                </div>
            <?php endif; ?>

            <p><strong><?php _e( 'Aggressive triggers to increase redirection rate.', 'bpcir' ) ?></strong></p>
            <table class="form-table" <?php echo $license_status !== 'valid' ? 'style="opacity:0.5; pointer-events:none;"' : ''; ?>>
                <tbody>
                    <tr>
                        <th scope="row"><?php _e( 'Back Button Redirect', 'bpcir' ); ?></th>
                        <td>
                            <label>
                                <input type="checkbox" name="bpcir_options[triggers][back_button]" value="1" <?php checked( 1, isset( $bpcir_options['triggers']['back_button'] ) ? $bpcir_options['triggers']['back_button'] : 0 ); ?>>
                                <?php _e( 'Redirect when user clicks the browser back button (Mobile & Desktop).', 'bpcir' ); ?>
                            </label>
                        </td>
                    </tr>
                    <tr>
                        <th scope="row"><?php _e( 'Scroll Redirect', 'bpcir' ); ?></th>
                        <td>
                            <label>
                                <input type="checkbox" name="bpcir_options[triggers][scroll]" value="1" <?php checked( 1, isset( $bpcir_options['triggers']['scroll'] ) ? $bpcir_options['triggers']['scroll'] : 0 ); ?>>
                                <?php _e( 'Redirect when user scrolls down.', 'bpcir' ); ?>
                            </label>
                        </td>
                    </tr>
                    <tr>
                        <th scope="row"><?php _e( 'Scroll Percentage', 'bpcir' ); ?></th>
                        <td>
                            <input type="number" name="bpcir_options[triggers][scroll_percentage]" class="small-text" value="<?php echo isset( $bpcir_options['triggers']['scroll_percentage'] ) ? esc_attr( $bpcir_options['triggers']['scroll_percentage'] ) : 60; ?>"> %
                            <p class="description"><?php _e( 'Percentage of page height to trigger redirection.', 'bpcir' ); ?></p>
                        </td>
                    </tr>
                    <tr>
                        <th scope="row"><?php _e( 'Copy/Paste Redirect', 'bpcir' ); ?></th>
                        <td>
                            <label>
                                <input type="checkbox" name="bpcir_options[triggers][copy]" value="1" <?php checked( 1, isset( $bpcir_options['triggers']['copy'] ) ? $bpcir_options['triggers']['copy'] : 0 ); ?>>
                                <?php _e( 'Redirect when user copies text from the page.', 'bpcir' ); ?>
                            </label>
                        </td>
                    </tr>
                </tbody>
            </table>
        </div>

        <div class="license" <?php echo $active_tab != "license" ? 'style="display:none;' : ""; ?>>
            <p><strong><?php _e( 'Manage your plugin license.', 'bpcir' ) ?></strong></p>
            <table class="form-table">
                <tbody>
                    <tr>
                        <th scope="row"><?php _e( 'License Key', 'bpcir' ); ?></th>
                        <td>
                            <input type="text" name="bpcir_options[license][key]" class="regular-text" value="<?php echo isset( $bpcir_options['license']['key'] ) ? esc_attr( $bpcir_options['license']['key'] ) : ''; ?>">
                            <p class="description"><?php _e( 'Enter your license key received after purchase.', 'bpcir' ); ?></p>
                        </td>
                    </tr>
                    <tr>
                        <th scope="row"><?php _e( 'Status', 'bpcir' ); ?></th>
                        <td>
                            <?php 
                                $status = isset( $bpcir_options['license']['status'] ) ? $bpcir_options['license']['status'] : 'inactive';
                                if ( $status === 'valid' ) {
                                    echo '<span style="color:green; font-weight:bold;">' . __( 'Active', 'bpcir' ) . '</span>';
                                } else {
                                    echo '<span style="color:red; font-weight:bold;">' . __( 'Inactive', 'bpcir' ) . '</span>';
                                }
                            ?>
                        </td>
                    </tr>
                    <tr>
                        <th scope="row"><?php _e( 'Connection Test', 'bpcir' ); ?></th>
                        <td>
                            <button type="button" id="bpcir_test_connection" class="button"><?php _e( 'Test Connection to Tracker', 'bpcir' ); ?></button>
                            <span id="bpcir_connection_status" style="margin-left: 10px;"></span>
                            <div id="bpcir_connection_details" style="margin-top: 10px; display: none; background: #f0f0f0; padding: 10px; border: 1px solid #ccc; white-space: pre-wrap; max-width: 600px; overflow-x: auto;"></div>
                        </td>
                    </tr>
                </tbody>
            </table>
        </div>

        <div class="documentation" <?php echo $active_tab != "documentation" ? 'style="display:none;' : ""; ?>>
            <div class="card" style="max-width: 100%; padding: 20px; margin-top: 20px;">
                <h2 style="margin-top:0;"><?php _e('Documentation & Guide', 'bpcir'); ?></h2>
                <p><?php _e('BPC Redirector helps you recover lost traffic by redirecting visitors who are about to leave your site or who are inactive.', 'bpcir'); ?></p>
                
                <h3><?php _e('Configuration Guide', 'bpcir'); ?></h3>
                <ul style="list-style-type: disc; margin-left: 20px;">
                    <li><strong>Inactivity:</strong> <?php _e('Redirects users who stay idle for a specific amount of time. Great for waking up "sleeping" visitors.', 'bpcir'); ?></li>
                    <li><strong>Early Leave:</strong> <?php _e('Detects when a user moves their mouse towards the top of the browser (Exit Intent) to close the tab or change URL.', 'bpcir'); ?></li>
                </ul>

                <h3><?php _e('Practical Tips', 'bpcir'); ?></h3>
                <ul style="list-style-type: disc; margin-left: 20px;">
                    <li><?php _e('Use a landing page with a strong offer (discount, free ebook) as the redirection URL.', 'bpcir'); ?></li>
                    <li><?php _e('Do not set the timeout too short to avoid annoying engaged readers.', 'bpcir'); ?></li>
                    <li><?php _e('Test your redirection URLs to ensure they work correctly.', 'bpcir'); ?></li>
                </ul>
            </div>

        </div>

        <script type="text/javascript">
        jQuery(document).ready(function($) {
            $('#bpcir_test_connection').on('click', function() {
                var $btn = $(this);
                var $status = $('#bpcir_connection_status');
                var $details = $('#bpcir_connection_details');

                $btn.prop('disabled', true).text('<?php _e( 'Testing...', 'bpcir' ); ?>');
                $status.text('');
                $details.hide().text('');

                $.post(ajaxurl, {
                    action: 'bpcir_test_connection'
                }, function(response) {
                    $btn.prop('disabled', false).text('<?php _e( 'Test Connection to Tracker', 'bpcir' ); ?>');
                    
                    if (response.success) {
                        $status.css('color', 'green').text(response.data.message);
                        if (response.data.response) {
                            $details.text(response.data.response).show();
                        }
                    } else {
                        $status.css('color', 'red').text(response.data);
                    }
                }).fail(function() {
                    $btn.prop('disabled', false).text('<?php _e( 'Test Connection to Tracker', 'bpcir' ); ?>');
                    $status.css('color', 'red').text('<?php _e( 'AJAX Error', 'bpcir' ); ?>');
                });
            });
        });
        </script>

        <p class="submit">
            <input type="submit" id="submit" name="submit" class="button button-primary" value="<?php _e( 'Save Changes', 'bpcir' ); ?>">
        </p>
    </form>
    </div>
</div>
