<?php

// Registering Redirector scripts.

defined( "WPINC" ) || die;

// Admin repeater field
wp_register_script(
    'bpc-repeater',
    plugins_url(
        'assets/js/admin/repeater-field/repeater.js',
        BPC_REDIRECTOR_PLUGIN_DIR . 'bpc_redirector.php'
    ),
    array("jquery", "wp-util")
);

wp_register_script(
    'bpc-repeater-template',
    plugins_url(
        'assets/js/admin/repeater-field/template.php',
        BPC_REDIRECTOR_PLUGIN_DIR . 'bpc_redirector.php'
    ),
    array("bpc-repeater-field")
);

// Cookie manager
wp_register_script(
    'cookie-manager',
    plugins_url(
        'assets/js/front/cookie-manager.js',
        BPC_REDIRECTOR_PLUGIN_DIR . 'bpc_redirector.php'
    ),
    array()
);

// Early leave
wp_register_script(
    'bpc-early-leave',
    plugins_url(
        'assets/js/front/early-leave.js',
        BPC_REDIRECTOR_PLUGIN_DIR . 'bpc_redirector.php'
    ),
    array("jquery", "cookie-manager")
);

// Inactivity script
wp_register_script(
    'bpc-inactivity',
    plugins_url(
        'assets/js/front/inactivity.js',
        BPC_REDIRECTOR_PLUGIN_DIR . 'bpc_redirector.php'
    ),
    array("jquery", "cookie-manager")
);

// Redirector script
wp_register_script(
    'bpc-redirector',
    plugins_url(
        'assets/js/front/redirector.js',
        BPC_REDIRECTOR_PLUGIN_DIR . 'bpc_redirector.php'
    ),
    array("jquery", "cookie-manager")
);

// Note: bpcir_send_telemetry function is now defined in bpc_redirector.php
// to ensure it's available during activation hook
