;(function($){
    // console.log(in_data);

    $.fn.inactivity = function(options, onInactivity) {

        var defaults = {
            cookie: "bpcito",
            cookieExp: 30,
            timeout: 600,
        };

        var opts = $.extend(defaults, options);
        console.log(opts);

        var activityCheck,
            watchedEvents = "mousemove keydown wheel DOMMouseScroll mousewheel mousedown touchstart touchmove MSPointerDown MSPointerMove",
            x,
            y;

        // Check presence of cookie, if not present (checkCookie returns false) proceed
        // if cookie present, (checkCookie returns true) abort;
        function checkCookie (name) {
            // Handle cookie
            if (opts.cookieExp <= 0) {
                cookieManager.erase(name);
                return false;
            }
            
            var objValue = getCookieShownValue();
            if( objValue === null ) { // cookie doesn't exist
                var xt = 0,
                    date = new Date();

                xt = date.setTime( date.getTime() + (opts.cookieExp * 24 * 60 * 60 * 1000) );
                
                var data = { 
                    its: new Date().getTime(), // last user activity time
                    lvl: 0, // links visited
                    xt: xt  // cookie expiration date
                };
                // create the cookie
                setCookieShownValue(data);
                return false;

            } else {    // cookie exists, inspect lvl property
                // console.log(objValue.lvl);
                if(objValue.lvl == "true") {
                    return true; // return true to abort redirection
                }else {
                    return false;
                }                
            }
        };

        function getCookieShownValue() {
            var strValue = cookieManager.get(opts.cookie),
                objValue = JSON.parse(strValue);
            return objValue;
        };

        function setCookieShownValue( objValue, newData ) {
            var data = $.extend(objValue, newData),
                strValue = JSON.stringify(data),
                expiry = new Date(objValue.xt).toGMTString();
            
            cookieManager.createWithTime(opts.cookie, strValue, expiry);
            // cookieManager.create(opts.cookie, strValue, opts.cookieExp);
        }

        /**
         * Sets the current time as a cookie.
         */
        function setTimestampCookie(evt) {
            // mousemove can act weird sometimes (always trigger even if mouse is still)
            // this tracks the location of the mouse 
            if (evt != undefined && evt.type == 'mousemove') {
                if (evt.clientX == x && evt.clientY == y){
                    return;
                }

                x = evt.clientX;
                y = evt.clientY;
            }

            var objValue = getCookieShownValue();            
            setCookieShownValue(objValue, { its: new Date().getTime() });
        };

        /**
         * Clear timers and restart the inactivity process.
         */
        function stopInactivityWatch() {
            clear();
        };

        /**
         * Clear inactivity watch.
         */
        function clear() {
            window.clearInterval(activityCheck);
            unbindEvents();
        };
        
        function checkInactivity() {
            var objValue = getCookieShownValue();
            var lvl = parseInt(objValue.lvl);
            var timestamp = parseInt(objValue.its);            
            var now = new Date().getTime();            

            var timeout = 0;
            if( parseInt(objValue.lvl) == 0) {
                timeout = parseInt(opts.timeout) * 1000; // default link timeout
            } else {
                timeout = parseInt(opts.urls.timeout[lvl - 1] * 1000); // secondary links
            }
            
            var inactivityCheck = timestamp + timeout;

            if (now >= inactivityCheck) {
                stopInactivityWatch();
                if(typeof onInactivity == 'function') {       
                    lvl++;
                    if(lvl > in_data.urls.link.length) {
                        lvl = "true"; // stop redirection
                    }                    

                    setCookieShownValue(objValue, {lvl: lvl});
                    setTimeout(function() {
                        onInactivity.call(this);
                    }, 500);                    
                }
            }
        };

        /**
         * Bind the observer events to the document
         */
        function bindEvents() {                
            $(document).bind($.trim((watchedEvents + " ").split(" ").join("._inactivityTimeout ")), function(e) {
                setTimestampCookie(e);
            });
        };

        function unbindEvents() {
            $(document).unbind("._inactivityTimeout");
        };

        /**
         * Begin inactivity watch.
         */
        function startInactivityWatch() {
            var cancel = checkCookie(opts.cookie);
            // console.log("cancel " + cancel);
            if( cancel !== null && cancel === true )
                return;

            setTimestampCookie();
            bindEvents();

            activityCheck = window.setInterval(checkInactivity, 1000);
        };
        
        // Spin it !
        startInactivityWatch();
    };
})(jQuery);
