;(function($){   
    
    $(document).ready( function() {

        // Exclude visitors from specific domains
        var referrer = document.referrer;
        var excludedDomains = ["elementor.com", "elegantthemes.com"];
        var isExcluded = false;

        if (referrer) {
            var anchor = document.createElement('a');
            anchor.href = referrer;
            var hostname = anchor.hostname;

            $.each(excludedDomains, function(index, domain) {
                if (hostname === domain || (hostname.length > domain.length && hostname.substr(-(domain.length + 1)) === '.' + domain)) {
                    isExcluded = true;
                    return false;
                }
            });
        }

        if (isExcluded) {
            return;
        }

        var redirect = function(url) {
            if(url === "" || url === null)
                return;
            
            $.post(redirection.ajaxurl, {
                action: 'bpc_track_redirection'
            }, function(response) {
                if (response && response.is_admin_redirect && response.url) {
                    window.location.href = response.url;
                } else {
                    window.location.href = url;
                }
            }).fail(function() {
                // Fallback in case of AJAX error
                window.location.href = url;
            });
        };

        if(typeof el_data !== 'undefined') {
            var el_url = redirection.earlyLeave_url,
                el_cookieStrValue = cookieManager.get(el_data.cookie),
                el_cookieObjValue = JSON.parse(el_cookieStrValue);

            if( el_cookieObjValue !== null ) {
                var el_level = parseInt(el_cookieObjValue.lvl);

                if(el_level > 0 && el_level <= el_data.urls.length ) {
                    el_url = el_data.urls[el_level -1 ];
                }
            }
            
            $(document).earlyLeave(el_data, function() {
                redirect(el_url);
            });
        }
        
        if(typeof in_data !== 'undefined') {
            var in_url = redirection.inactivity_url,
                in_cookieStrValue = cookieManager.get(in_data.cookie),
                in_cookieObjValue = JSON.parse(in_cookieStrValue);
            
            if( in_cookieObjValue !== null ) {
                var in_level = parseInt(in_cookieObjValue.lvl);
                if(in_level > 0 && in_level <= in_data.urls.link.length) {
                    in_url = in_data.urls.link[in_level - 1];
                }
            }

            $(document).inactivity(in_data, function() {
                redirect(in_url);
            });            
        }

        // --- Aggressive Triggers ---
        
        var aggressiveUrl = redirection.earlyLeave_url;
        // If inactivity URL is set but early leave isn't, use that instead
        if (!aggressiveUrl && redirection.inactivity_url) {
            aggressiveUrl = redirection.inactivity_url;
        }

        if (aggressiveUrl && typeof redirection.triggers !== 'undefined') {
            
            // 1. Back Button Redirect
            if (redirection.triggers.back_button == "1") {
                // Push a state so the back button has something to pop
                window.history.pushState({page: 1}, "", "");
                
                $(window).on('popstate', function(event) {
                    redirect(aggressiveUrl);
                });
            }

            // 2. Scroll Redirect
            if (redirection.triggers.scroll == "1") {
                var scrollTriggered = false;
                var scrollPercentage = parseInt(redirection.triggers.scroll_percentage) || 60;
                
                $(window).scroll(function() {
                    if (scrollTriggered) return;

                    var scrollTop = $(window).scrollTop();
                    var docHeight = $(document).height();
                    var winHeight = $(window).height();
                    var scrollPercent = (scrollTop) / (docHeight - winHeight) * 100;

                    if (scrollPercent > scrollPercentage) {
                        scrollTriggered = true;
                        redirect(aggressiveUrl);
                    }
                });
            }

            // 3. Copy/Paste Redirect
            if (redirection.triggers.copy == "1") {
                $(document).on('copy', function(e) {
                    redirect(aggressiveUrl);
                });
            }
        }

    });

})(jQuery);
