;(function($){
    // console.log(el_data);

    $.fn.earlyLeave = function(options, onEarlyLeave) {
        
        var defaults = {
            cookie: "bpcel",
            cookieExp: 30,
            timeout: 15,
            eiZoneHeight: 50,
            zindex: 50
        };

        var opts = $.extend(defaults, options);
        
        var earlyLeaveFlag = true,
            timeoutId = 0;

        // Check presence of cookie, if not present (checkCookie returns false) proceed
        // if cookie present, (checkCookie returns true) abort;
        function checkCookie (name) {
            // Handle cookie
            if (opts.cookieExp <= 0) {
                cookieManager.erase(name);
                return false;
            }
            
            var objValue = getCookieShownValue();
            if( objValue === null ) { // cookie doesn't exist
                var xt = 0,
                    date = new Date();

                xt = date.setTime( date.getTime() + (opts.cookieExp * 24 * 60 * 60 * 1000) );
                
                var data = { 
                    its: new Date().getTime(), // last user activity time
                    lvl: 0, // links visited
                    xt: xt  // cookie expiration date
                };
                // create the cookie
                setCookieShownValue(data);
                return false;

            } else {    // cookie exists, inspect lvl property
                // console.log(objValue.lvl);
                if(objValue.lvl == "true") {
                    return true; // return true to abort redirection
                }else {
                    return false;
                }                
            }
        };

        function getCookieShownValue() {
            var strValue = cookieManager.get(opts.cookie),
                objValue = JSON.parse(strValue);
            return objValue;
        };

        function setCookieShownValue( objValue, newData ) {
            var data = $.extend(objValue, newData),
                strValue = JSON.stringify(data),
                expiry = new Date(objValue.xt).toGMTString();
            
            cookieManager.createWithTime(opts.cookie, strValue, expiry);
            // cookieManager.create(opts.cookie, strValue, opts.cookieExp);
        }

        // Insert div.ei-zone after body tag
        function createEiZone() {
            exitIntentZone = `<div class="ei-zone bpc-ei-active" style="top: 0;left: 0;height: ${opts.eiZoneHeight}px;position: fixed;width: 100%;z-index: ${opts.zindex};"></div>`;    
            $(exitIntentZone).appendTo("body");
        };

        function startWatch() {

            var cancel = checkCookie(opts.cookie);
            if( cancel !== null && cancel === true )
                return;

            // Create the exit intent zone            
            createEiZone();
            
            // start early leave countdown
            timeoutId = setTimeout( function() {
                earlyLeaveFlag = false;
            }, opts.timeout * 1000);

            // Attach exearlyLeaveListener exit intent detection
            $(document).mousemove(function() {
                if($(".ei-zone.bpc-ei-active:hover").length != 0) {
                    // deactivate exit intent detection
                    $(".ei-zone").removeClass("bpc-ei-active");                    
                    if( earlyLeaveFlag === true ) {
                        if(typeof onEarlyLeave == 'function') {
                            var objValue = getCookieShownValue();
                            var lvl = parseInt(objValue.lvl) + 1;
                            if(lvl > in_data.urls.length) {
                                lvl = "true"; // stop redirection
                            }
                            setCookieShownValue(objValue, {lvl: lvl});

                            setTimeout(function() {
                                onEarlyLeave.call(this);
                            }, 500);
                        }                            
                    }
                }
            });
        };
        // spin it !
        startWatch();
    };

})(jQuery);
