;(function($){  
    $(document).ready( function() {
        
        var template = wp.template("bpc-repeater"),
            el_data = {
                feature: "earlyLeave",
                wrapper_class: "el-redirect-url"
            },
            in_data = {
                feature: "inactivity",
                wrapper_class: "in-redirect-url"
            };
        
        function add_repeater_field( data ) {
            html = template(data);

            var plural = `.${data.wrapper_class}s`;
            if($(plural).length === 0) {
                $(`.${data.wrapper_class}`).after( html );
            } else {
                $(plural).last().after( html );
            }
            $(plural).last().hide().fadeIn("slow");
        }

        function remove_repeater_field( element, wrapper_class ) {
            $(element).closest(`.${wrapper_class}`)
                .css("background","#e6103e").fadeOut(300, function() {
                    $(this).remove();
            });
        }
        
        // EarlyLeave
        // Add field
        $(document).on("click", ".earlyLeave .bpc-repeater-add", function(e){
            e.preventDefault();
            add_repeater_field(el_data);
        });        

        // Remove field
        $(document).on("click", ".earlyLeave .bpc-repeater-remove", function(e){
            e.preventDefault();
            remove_repeater_field( this, `${el_data.wrapper_class}s` );
        });

        // Inactivity
        // Add field
        $(document).on("click", ".inactivity .bpc-repeater-add", function(e){
            e.preventDefault();
            add_repeater_field(in_data);
        });        

        // Remove field
        $(document).on("click", ".inactivity .bpc-repeater-remove", function(e){
            e.preventDefault();
            remove_repeater_field( this, `${in_data.wrapper_class}s` );
        });
    });
})(jQuery);